<?xml version='1.0'?>
<xsl:stylesheet>
<xsl:output omit-xml-declaration="true" method="html" indent="no"/>

<xsl:param name="professionParam" select="'default'"/>

<!-- 	Outputs the main table of professions. Calls a template for 
	each PROFESSION_TYPE child node.
-->
<xsl:template match="/">
	<table id="blueBorder" width="100%" border="0" cellspacing="0" cellpadding="0">
	<tr id="wtback"> 
		<td width="100%" id="wtback"><!--Edit Occupation Header --> 
			<div id="normalText"><span id="headingBigGreen">Edit Occupation:</span>&#160;Check all that apply.<p/></div>
			<!--Start Occupations check boxes content table Table --> 
			<table width="100%" border="0" cellspacing="0" cellpadding="4">
				<xsl:apply-templates select="PROFESSION_TYPE/PROFESSION_TYPE"/>
			<tr align="center"> 
				<td colspan="6"><input type="image" src="images/buttons_sm_submit.gif" width="124" height="30" vspace="10" alt="Submit" border="0"/></td>
			</tr>
			</table>
		</td>
	</tr>
	</table>
</xsl:template>

<!--	
	Template for PROFESSION_TYPE nodes. Outputs a row for the 
	profession type and calls the "doRow" template for every 3rd 
	profession.
-->	
<xsl:template match="PROFESSION_TYPE">
	<tr id="ltblueback"> 
		<td colspan="6">
			<span id="normaltext"><b>
		<xsl:value-of select="PROFESSION_TYPE_DESC"/>
			</b>:</span>
		</td>
		<xsl:apply-templates select="descendant::PROFESSION_ITEM[position() mod 3 = 1]" mode="doRows"/>
	</tr>

</xsl:template>

<!-- 	"doRow" Template for PROFSSION nodes. 
	This template organizes the professions into rows, using 
	3 items per row.
-->
<xsl:template match="PROFESSION_ITEM" mode="doRows">
	<tr>
		<xsl:apply-templates select="." mode="showCheckbox"/>
		<xsl:apply-templates select="following-sibling::*[position() &lt; 3]" mode="showCheckbox"/>
	</tr>
</xsl:template>

<!-- 	This template displays a single profession as a checkbox. For the 
	profession named Other, it outputs a text input box as well.
-->
<xsl:template match="PROFESSION_ITEM" mode="showCheckbox">
	<xsl:variable name="prodDesc">
		<xsl:value-of select="PROFESSION_DESC"/>
	</xsl:variable>
	
	<td> <span id="normaltext"> 
	<input type="checkbox">
		<xsl:attribute name="name"><xsl:value-of select="$professionParam"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="PROFESSION_ID"/></xsl:attribute>

	</input>
	</span></td>
	<td width="150"><span id="normaltext">
		<xsl:value-of select="PROFESSION_DESC"/>
		<!-- Display the text box for the "Other" Profession 
		-->
		<xsl:if test="$prodDesc = 'Other'">
			
			<input type="text" name="professionOther" value="Puppeteer"/>
		</xsl:if>
	</span>
	</td>
</xsl:template>

</xsl:stylesheet>
